﻿
CREATE PROCEDURE [App].[NVCC_usp_UniqueVeterans]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : App.NVCC_usp_UniqueVeterans
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 11-02-2016
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get aggregated counts of RDPs and unique veterans at
--                        station and VISN levels of aggregation
--==================================================================================

BEGIN
	SELECT 
		pl.PatientICN, pl.Sta3n, s.VISNFY17, s.DistrictNumberFY17 AS District
	INTO #TMP
	FROM 
		App.NVCC_ProductionLog pl
		INNER JOIN CDWWork.Dim.Sta3n s
			ON pl.Sta3n = s.Sta3n

	SELECT
		ROW_NUMBER() OVER (ORDER BY District, VISNFY17, Sta3n) AS ID,
		District,
		VISNFY17,
		Sta3n,
		App.udf_StationName(Sta3n) AS Station,
		RDP,
		UniqueVeterans
	FROM (
		SELECT
			District,
			VISNFY17,
			Sta3n,
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP
		GROUP BY Sta3n, VISNFY17, District
		UNION
		SELECT
			District,
			VISNFY17,
			NULL AS Sta3n,
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP
		GROUP BY VISNFY17, District
		UNION
		SELECT
			District,
			NULL AS VISNFY17,
			NULL AS Sta3n, 
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP
		GROUP BY District
		UNION
		SELECT
			NULL AS District,
			NULL AS VISNFY17,
			NULL AS Sta3n, 
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP

	) A
	ORDER BY District, VISNFY17, Sta3n

	DROP TABLE #TMP
END

